// Copyright 1995 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "preferen.h"
#include "options.h"
#include "display.h"

// No Colors page if we are on a mono system.
static const DWORD monoHelpIDs[] =
{
    1009,
    1018,
    1027
};

static const DWORD helpIDs[] =
{
    1009,
    1004,
    1018,
    1027
};

// CPreferencesSheet

IMPLEMENT_DYNAMIC(CPreferencesSheet, CPropertySheet)

CPreferencesSheet::CPreferencesSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
}

CPreferencesSheet::CPreferencesSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
}

CPreferencesSheet::~CPreferencesSheet()
{
}


BEGIN_MESSAGE_MAP(CPreferencesSheet, CPropertySheet)
	//{{AFX_MSG_MAP(CPreferencesSheet)
        ON_COMMAND(ID_HELP,OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPreferencesSheet message handlers

void CPreferencesSheet::OnHelp()
{
    if (Display::is_mono())
        AfxGetApp()->WinHelp(monoHelpIDs[GetPageIndex(GetActivePage())]);
    else
        AfxGetApp()->WinHelp(helpIDs[GetPageIndex(GetActivePage())]);

}
